# 🔁 Technology Lifecycle Declaration (TLD)

This document declares the **technology stack and runtime versions** used by this component,
aligned with **https://endoflife.date**.

Its purpose is to:
- Track End-of-Life (EOL) risks
- Enable proactive upgrades
- Support security and compliance audits
- Enable automation and validation in CI/CD pipelines

---

## 🖥️ Infrastructure Runtime & Technology Lifecycle

All components are deployed using **Docker containers on Azure App Service (PaaS)**.
This matrix declares the **runtime, base code, and framework lifecycle** for each workload.

🚫 **New developments MUST NOT use EOL or near-EOL components.**

---

### 🔁 Technology Lifecycle Matrix

| Framework | PaaS Component | Container Base OS | OS EOL | Base Code Language | Language Version | Language EOL | Framework Version | Framework EOL | Notes |
|---------|----------------|------------------|--------|-------------------|------------------|--------------|------------------|---------------|------|
| FastAPI | App Service (Docker) | Ubuntu 22.04 | Apr 2027 | Python | 3.11 | Oct 2027 | FastAPI 0.128.0 | TBD | Standard Python API |
| Django | App Service (Docker) | Ubuntu 22.04 | Apr 2027 | Python | 3.11 | Oct 2027 | Django 5.x | Dec 2027 | Django REST API |
| ASP.NET Web API | App Service (Docker) | Ubuntu 22.04 | Apr 2027 | .NET | .NET 8 LTS | Nov 2026 | ASP.NET Core | Nov 2026 | REST API |
| ASP.NET Web App | App Service (Docker) | Ubuntu 22.04 | Apr 2027 | .NET | .NET 8 LTS | Nov 2026 | ASP.NET Core MVC | Nov 2026 | MVC / Razor |
| Ocelot API Gateway | App Service (Docker) | Ubuntu 22.04 | Apr 2027 | .NET | .NET 8 LTS | Nov 2026 | Ocelot 23.x | TBD | API Gateway |
| Angular | App Service (Docker) | Node 20 (Debian) | Apr 2026 | Node.js | 20 LTS | Apr 2026 | Angular 17 | Nov 2025 | Frontend SPA |

---

### 🚨 Lifecycle Enforcement Rules

- ❌ **EOL components MUST NOT be deployed**
- ⚠️ **Components within 6 months of EOL require an upgrade plan**
- ✅ **LTS versions are mandatory for new developments**
- 🔁 Lifecycle review is required **on every release**

---

### 📎 Lifecycle References

- https://endoflife.date
- Microsoft .NET Lifecycle Policy
- Azure App Service Container Documentation
- Azure Well-Architected Framework
