# 🌐 🔓 Public API Documentation (No authentication required)

## ⚠️ Important Operational Note

This documentation is **for informational purposes** and should be kept **outside of production CI/CD processes**.

No modifications to this repository should trigger restarts, deployments, or automated executions in production environments.

```yaml
trigger:
  branches:
    include:
    - main
  paths:
    include:
    - Microservice/*
    exclude:
    - Microservice/docs/**
    - Microservice/docs-private/**
    - Microservice/*.md
    - '*.md' # root path
```


## 📖 Table of Contents

📌Note: **It is recommended that each developer create a README.md file in their repo code with the table of contents to the files, serving as an index like index.html. This way, when converted to HTML using mkdocs, it is not necessary to manage menus for each repo; instead, each repo manages its own menu like a landing page.**

### Overview
- [About This Component](docs/about.md)
- [Overview](docs/overview/README.md)
- [Authentication](docs/overview/authentication.md)

### API Reference
- [API Overview](docs/api/README.md)
- [Endpoints](docs/api/endpoints.md)
- [Error Handling](docs/api/errors.md)

### Usage
- [Getting Started](docs/usage/getting-started.md)
