# 🌐 🔐 Private API Documentation (Authentication Required)

This documentation is **restricted to internal teams** and describes  
the **internal architecture, security, data access, and operational behavior**  
of the API.

---

## ⚠️ Important Operational Note

This documentation is **for informational purposes** and should be kept **outside of production CI/CD processes**.

No modifications to this repository should trigger restarts, deployments, or automated executions in production environments.

```yaml
trigger:
  branches:
    include:
    - main
  paths:
    include:
    - Microservice/*
    exclude:
    - Microservice/docs/**
    - Microservice/docs-private/**
    - Microservice/*.md
    - '*.md' # root path
```
---

## 📖 Table of Contents

📌Note: **It is recommended that each developer create a README.md file in their repo code with the table of contents to the files, serving as an index like index.html. This way, when converted to HTML using mkdocs, it is not necessary to manage menus for each repo; instead, each repo manages its own menu like a landing page.**

### Overview
- [About This Component](docs-private/about.md)

### Architecture
- [System Overview](docs-private/architecture/system-overview.md)

### Security
- [JWT Validation](docs-private/security/jwt-validation.md)

### Data Layer
- [Database Queries](docs-private/data/queries.md)

### Technology Lifecycle Declaration (TLD)
- [Lifecycle](docs-private/lifecycle/technology-lifecycle.md)

### Business Logic
- [Business Rules](docs-private/business-logic/rules.md)

### Operations
- [Runbooks](docs-private/operations/runbooks.md)